<?php
$logFile = __DIR__ . '/webhook.log';

file_put_contents($logFile, "[" . date("H:i:s") . "] Webhook hit\n", FILE_APPEND);

// 1. Get the shop domain
$shopDomain = $_SERVER['HTTP_X_SHOPIFY_SHOP_DOMAIN'] ?? '';
file_put_contents($logFile, "[" . date("H:i:s") . "] From domain: $shopDomain\n", FILE_APPEND);

// 2. Load data from Google Sheet via Apps Script
$googleSheetURL = 'https://script.google.com/macros/s/AKfycbxlLtjK21JK767dutRifrxuoLbIKtdvf3OGGq_W8iWdiYMdhH-4oLnQ8F2Fn-njLYpL/exec'; // Replace with yours
$response = file_get_contents($googleSheetURL);
file_put_contents($logFile, "[" . date("H:i:s") . "] Sheet response: $response\n", FILE_APPEND);

$storeList = json_decode($response, true);

// Validate JSON
if (!is_array($storeList)) {
    file_put_contents($logFile, "[" . date("H:i:s") . "] ❌ Invalid JSON from sheet\n", FILE_APPEND);
    http_response_code(200);
    exit;
}

// 3. Try to match the domain
$storeUrl = null;

foreach ($storeList as $storeEntry) {
    $url = $storeEntry['store'] ?? '';
    $urlParts = parse_url($url);
    $host = $urlParts['host'] ?? '';

    file_put_contents($logFile, "[" . date("H:i:s") . "] Checking store: $url | host: $host\n", FILE_APPEND);

    if ($host && stripos($host, $shopDomain) !== false) {
        $storeUrl = $url;
        file_put_contents($logFile, "[" . date("H:i:s") . "] ✅ Matched: $storeUrl\n", FILE_APPEND);
        break;
    }
}

// 4. Send POST to Google Script to increment sale
if ($storeUrl) {
    $payload = json_encode(['store' => $storeUrl]);

    $ch = curl_init($googleSheetURL);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    $result = curl_exec($ch);
    curl_close($ch);

    file_put_contents($logFile, "[" . date("H:i:s") . "] Sent POST. Result: $result\n", FILE_APPEND);
} else {
    file_put_contents($logFile, "[" . date("H:i:s") . "] ❌ No match for domain: $shopDomain\n", FILE_APPEND);
}

http_response_code(200);
echo "OK";