<?php
$googleSheetURL = 'https://script.google.com/macros/s/AKfycbxlLtjK21JK767dutRifrxuoLbIKtdvf3OGGq_W8iWdiYMdhH-4oLnQ8F2Fn-njLYpL/exec'; // Replace with your actual script URL

function updateCache($url) {
    $response = file_get_contents($url);
    $data = json_decode($response, true);

    $logFile = __DIR__ . '/refresh.log';
    $cacheFile = __DIR__ . '/cache.json';

    // Delete old cache if it exists
    if (file_exists($cacheFile)) {
        unlink($cacheFile);
    }

    if (!is_array($data)) {
        file_put_contents($logFile, "[" . date("H:i:s") . "] ❌ Invalid JSON or empty sheet response\n", FILE_APPEND);
        return;
    }

    $selectedStore = null;

    foreach ($data as $entry) {
        $enabled = strtolower(trim($entry['enabled'] ?? 'no'));
        $target = intval($entry['target_sales'] ?? 1);
        $current = intval($entry['current_sales'] ?? 0);

        if ($enabled === 'yes' && $current < $target) {
            $selectedStore = $entry['store'];
            break;
        }
    }

    if ($selectedStore) {
        file_put_contents($cacheFile, json_encode(['store' => $selectedStore], JSON_PRETTY_PRINT));
        file_put_contents($logFile, "[" . date("H:i:s") . "] ✅ Cache updated: $selectedStore\n", FILE_APPEND);
    } else {
        file_put_contents($logFile, "[" . date("H:i:s") . "] ❌ No eligible store found (all reached target or disabled)\n", FILE_APPEND);
    }
}

updateCache($googleSheetURL);